#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/core_dump_dest_analyzer.sh /main/2 2011/01/12 18:13:46 nvira Exp $
#
# core_dump_dest_analyzer.sh
#
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      core_dump_dest_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       10/04/10 - shell script to analyze results of core dump dest
#                           sql query
#    nvira       10/04/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

# Set default exit message to indicate failure.
result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking core dump destination</EXEC_ERROR><TRACE>Error while checking core dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2874</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"
existstatus=3
dbName=$1
ageInDays=$2
expectedCount=$3
analyzerFileList=$4

analyzerPath=$(/bin/sh -c "$SGREP PATH $analyzerFileList | $SAWK -F= '{print \$2}'")
analyzerFileName=$(/bin/sh -c "$SGREP GLOBAL $analyzerFileList | $SAWK -F= '{print \$2}'")

analyzerFile=$analyzerPath/$analyzerFileName


resultSet="<RESULTSET>"
existstatus=0

while read LINE
do
  if [ "x$LINE" != "x" ]
  then
    cdump_dest=`echo "$LINE" | $SAWK '{print $2}'`
    instance_id=`echo "$LINE" | $SAWK '{print $1}'`
    instance_id=${dbName}"("${instance_id}")"
    tempCount=0
    count=0

    command="find $cdump_dest -name '*.trc' -mtime +$ageInDays 2>/dev/null |wc -l"
    count=$(/bin/sh -c "$command")
    ret=$?

    if [ $ret -eq 0 ]
    then
      if [ $count -le $expectedCount ]
        then
          resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest not have too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2872</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      else
          resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>core_dump_dest has too many old core dump files</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2873</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      fi   
    else
      resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking core dump destination</EXEC_ERROR><TRACE>Error while checking background dump destination</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2874</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
    fi   
  fi
done <$analyzerFile

resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $existstatus

